/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package eeconsumertopic;

import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Resource;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.JMSConsumer;
import javax.jms.JMSContext;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.Queue;
import javax.jms.TextMessage;
import javax.jms.Topic;

/**
 *
 * @author Stefan
 */
public class EEConsumerTopic {

    @Resource(lookup = "jms/__defaultConnectionFactory")
    private static ConnectionFactory connectionFactory;
    @Resource(lookup = "MyQueue")
    private static Queue queue;
    @Resource(lookup = "MyTopic")
    private static Topic topic;
    
    public static void main(String[] args) {
        try {
            int idC = Integer.parseInt(args[0]);
            JMSContext context = connectionFactory.createContext();
            context.setClientID("id" + idC);
            JMSConsumer consumer = context.createDurableConsumer(topic, "B"); // Durable & NotShared
            
            while(true){
                Message message = consumer.receive();
                if(message instanceof TextMessage){
                    System.out.println("Primljena je poruka sa sadrzajem: " + ((TextMessage)message).getText());
                }
                else{
                    System.out.println("Primljena je prazna poruka.");
                    break;
                }
            }
            
        } catch (JMSException ex) {
            Logger.getLogger(EEConsumerTopic.class.getName()).log(Level.SEVERE, null, ex);
        }
    }
    
}
